from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math
import DSLHaz

class BoxArena(Arenas.SuperArena):
    "Back to the Schoolyard for this fight. Don't get wet, and mind the bully doesn't kick out about too much."
    name = "DSL Schoolyard Arena"
    preview = "DSLSchoolYard/schoolyardarena_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-30, 30, 30, -30)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLSchoolYard/schoolyardarena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)

        degrad = 0.01745
        self.AddStaticCamera("              StaticCam-1", (0, 30, 0), (90*degrad,math.pi), 60*degrad)
        self.AddStaticCamera("              StaticCam-2", (0, 15, 12), (45*degrad,math.pi), 84*degrad)
        self.AddStaticCamera("              StaticCam-3", (0, 20, 14), (60*degrad,math.pi), 84*degrad)
        self.AddStaticCamera("              StaticCam-4", (0, 24, 16), (75*degrad,math.pi), 84*degrad)

        self.AddWatchCamera("               WatchCam-1", (0, 20, 9), (6, 20, 40*degrad, 20*degrad))
        self.AddWatchCamera("               WatchCam-2", (0, 22, 12), (6, 22, 50*degrad, 30*degrad))
        self.AddWatchCamera("               WatchCam-3", (0, 24, 15), (6, 24, 60*degrad, 40*degrad))
        self.AddWatchCamera("               Bully-cam", (-7.1, 7, 19.3), (6, 18, 50*degrad, 30*degrad))

        self.players = ()

        self.chargetimer = 0.0
        self.zaptimer = 0.0
        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        # Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.676244,1.83754), (-12.4182,0.676244,12.4283), (-12.4182,0.676244,1.83754))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-8.17686,0.676244,12.4283), (-12.4182,0.676244,12.4283))
        self.AddShadowTriangle((-8.17686,0.676244,9.91855), (-12.4182,0.676244,12.4283), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.25999,0.676244,12.4283), (-2.49123,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (2.25999,0.676244,12.4283), (-2.49123,0.676244,9.91855))
        self.AddShadowTriangle((12.413,0.676244,12.4283), (7.93297,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,12.4283), (7.93297,0.676244,9.91855))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (12.413,0.676244,1.91641), (12.413,0.676244,12.4283))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (12.413,0.676244,-12.4279), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (12.413,0.676244,-12.4279), (12.413,0.676244,-1.93329))
        self.AddShadowTriangle((8.17711,0.676244,-9.92447), (8.17711,0.676244,-12.4279), (12.413,0.676244,-12.4279))
        self.AddShadowTriangle((-2.26871,0.676244,-12.4279), (2.49519,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (-2.26871,0.676244,-12.4279), (2.49519,0.676244,-9.92447))
        self.AddShadowTriangle((-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-12.4279), (-7.93688,0.676244,-9.92447))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-12.4182,0.676244,-1.8361), (-12.4182,0.676244,-12.4279))
        self.AddShadowTriangle((-2.49123,0.676244,9.91855), (-8.17686,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((2.49519,0.676244,-9.92447), (8.17711,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (-10.2877,0.676244,-1.8361), (-2.26871,0.676244,-9.92447))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (7.93297,0.676244,9.91855), (2.25999,0.676244,9.91855))
        self.AddShadowTriangle((2.25999,0.676244,9.91855), (-2.49123,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,1.91641), (2.25999,0.676244,9.91855), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((10.2878,0.676244,-1.93329), (10.2878,0.676244,1.91641), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (10.2878,0.676244,-1.93329), (-10.2877,0.676244,1.83754))
        self.AddShadowTriangle((-2.26871,0.676244,-9.92447), (2.49519,0.676244,-9.92447), (10.2878,0.676244,-1.93329))
        self.AddShadowTriangle((-10.2877,0.676244,-1.8361), (-7.93688,0.676244,-9.92447), (-2.26871,0.676244,-9.92447))
        
        # Hazard Shadow Triangles
        self.AddShadowTriangle((-8.0217,0.407085,-12.2193), (-2.21868,0.407085,-12.2193), (-2.21868,0.407085,-9.90302))
        self.AddShadowTriangle((-2.21868,0.407085,-9.90302), (-8.0217,0.407085,-9.90302), (-8.0217,0.407085,-12.2193))
        self.AddShadowTriangle((2.42165,0.407085,-12.2193), (8.22466,0.407085,-12.2193), (8.22466,0.407085,-9.90302))
        self.AddShadowTriangle((8.22466,0.407085,-9.90302), (2.42165,0.407085,-9.90302), (2.42165,0.407085,-12.2193))
        self.AddShadowTriangle((-8.24321,0.407085,9.84521), (-2.4402,0.407085,9.84521), (-2.4402,0.407085,12.1615))
        self.AddShadowTriangle((-2.4402,0.407085,12.1615), (-8.24321,0.407085,12.1615), (-8.24321,0.407085,9.84521))
        self.AddShadowTriangle((2.20013,0.407085,9.84521), (8.00315,0.407085,9.84521), (8.00315,0.407085,12.1615))
        self.AddShadowTriangle((8.00315,0.407085,12.1615), (2.20013,0.407085,12.1615), (2.20013,0.407085,9.84521))
        
    def HazardsOn(self, on):
        self.RegisterZone("zap1_zone", 2)
        self.RegisterZone("zap2_zone", 3)
        self.RegisterZone("zap3_zone", 4)

        self.electricity = Hazards.Electricity((.016, -.818, .001))
        self.AddHazard(self.electricity)

        self.RegisterZone("kick_zone", 1)
        hinge = self.GetHinge("leghinge")
        self.bully = DSLHaz.HellRaiser(hinge, (-6, 2.5, 20))
        self.AddHazard(self.bully)
        self.SetSubMaterialSound("kicker", "metal", 1.0, "Sounds\\hzd_comp_hit.wav")

        self.CreateLightning(0, (-4, -2.2, 0), (0, -2.2, 0))
        self.CreateLightning(1, (0, -2.1, 0), (-4, -2.1, 0))
        self.CreateLightning(2, (-4, -2.0, 0), (0, -2.0, 0))
        self.CreateLightning(3, (0, -2.2, 3.4), (0, -2.2, 0))
        self.CreateLightning(4, (0, -2.1, 0), (0, -2.1, 3.4))
        self.CreateLightning(5, (0, -2.0, 3.4), (0, -2.0, 0))
        self.CreateLightning(6, (4, -2.2, 0), (0, -2.2, 0))
        self.CreateLightning(7, (0, -2.1, 0), (4, -2.1, 0))
        self.CreateLightning(8, (4, -2.0, 0), (0, -2.0, 0))
        self.CreateLightning(9, (0, -2.2, -3.4), (0, -2.2, 0))
        self.CreateLightning(10, (0, -2.1, 0), (0, -2.1, -3.4))
        self.CreateLightning(11, (0, -2.0, -3.4), (0, -2.0, 0))
            
        n = 0
        while n < 12:
            self.SetLightningVisible(n, True)
            n += 1

        return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)


    def ZoneEvent(self, direction, id, robot, chassis):

        if id ==1 and direction ==1:
            self.bully.RaiseHell()
        elif id==2:
            self.electricity.ZoneEvent(direction, robot, chassis)
        elif id==3:
            self.electricity.ZoneEvent(direction, robot, chassis)
        elif id==4:
            self.electricity.ZoneEvent(direction, robot, chassis)

        return True


    def Tick(self):
        self.electricity.Tick()
        
        if self.zaptimer > 0:
            self.zaptimer -= .25
            if self.zaptimer <= 0:
                self.SetAllLightningVisible(False)
                self.ResetLightningPositions()
        
        if self.chargetimer > 0.0:
            self.chargetimer -= .25
            if self.chargetimer <= 0.0:
                self.SetLightningVisible(0, True)
                self.SetLightningVisible(1, True)
                self.SetLightningVisible(2, True)
                self.chargetimer = 0.0
            elif self.chargetimer <= 1.25:
                self.SetLightningVisible(3, True)
                self.SetLightningVisible(4, True)
                self.SetLightningVisible(5, True)
            elif self.chargetimer <= 2.5:
                self.SetLightningVisible(6, True)
                self.SetLightningVisible(7, True)
                self.SetLightningVisible(8, True)
            elif self.chargetimer <= 3.75:
                self.SetLightningVisible(9, True)
                self.SetLightningVisible(10, True)
                self.SetLightningVisible(11, True)
        self.bully.Tick()


        #check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < -20:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)

    def Charge(self, time, bots):
        self.chargetimer = time
        self.zaptimer = .5
        self.SetAllLightningVisible(False)
        
        n = 0
        for bot, in_range in bots.iteritems():
            if in_range:
                self.SetLightningStartEnd(n, (0, -2.2, 0), plus.getLocation(bot))
                self.SetLightningStartEnd(n+1, plus.getLocation(bot), (0, -2.1, 0))
                self.SetLightningStartEnd(n+2, (0, -2.0, 0), plus.getLocation(bot))
                self.SetLightningVisible(n, True)
                self.SetLightningVisible(n+1, True)
                self.SetLightningVisible(n+2, True)
                n+=3
            
    def ResetLightningPositions(self):
        self.SetLightningStartEnd(0, (-4, -2.2, 0), (0, -2.2, 0))
        self.SetLightningStartEnd(1, (0, -2.1, 0), (-4, -2.1, 0))
        self.SetLightningStartEnd(2, (-4, -2.0, 0), (0, -2.0, 0))
        self.SetLightningStartEnd(3, (0, -2.2, 3.4), (0, -2.2, 0))
        self.SetLightningStartEnd(4, (0, -2.1, 0), (0, -2.1, 3.4))
        self.SetLightningStartEnd(5, (0, -2.0, 3.4), (0, -2.0, 0))
        self.SetLightningStartEnd(6, (4, -2.2, 0), (0, -2.2, 0))
        self.SetLightningStartEnd(7, (0, -2.1, 0), (4, -2.1, 0))
        self.SetLightningStartEnd(8, (4, -2.0, 0), (0, -2.0, 0))
        self.SetLightningStartEnd(9, (0, -2.2, -3.4), (0, -2.2, 0))
        self.SetLightningStartEnd(10, (0, -2.1, 0), (0, -2.1, -3.4))
        self.SetLightningStartEnd(11, (0, -2.0, -3.4), (0, -2.0, 0))
    
    def SetAllLightningVisible(self, bVisible):
        for n in range(12):
            self.SetLightningVisible(n, bVisible)
        
Arenas.register(BoxArena)
